$fs=0.05;
$fa=0.5;
lrg_gn=80.5;
htr_gn=151.2;
eps_gn=10;
ray_gn=15;

pos_jac=18.5;
lrg_jac=8;
pos_usb=0;
lrg_usb=16;

eps_btn=0.5;
pos_ma=50;
htr_ma=15;
pos_vol=45;
htr_vol=25;

jeu_gn_flanc=1;
lrg_flanc=7;

eps_res=1;
eps_bride=5;
clips=0.5;
ray_pate=1.5;
lrg_pate=30;
ray_anneau=4;
ray_vis=1.5;
lrg_bp=5;

//----- Rectangle à coins arrondis -----
module rSquare(size, radius)
	{
	square(size - [2*radius,0], true);
	square(size - [0,2*radius], true);
	for ( x = [radius-size[0]/2, -radius+size[0]/2],
		  y = [radius-size[1]/2, -radius+size[1]/2])
		{
		translate([x,y])circle(r=radius, center=true);
		}
	}

//----- Profil du Galaxy Note 2 (vert)-----
module GN2(jeu)
	{
	color([0,1,0]) rSquare([lrg_gn+2*jeu,htr_gn+2*jeu], ray_gn+jeu, false);
	color([1,0,0])
		{
	}

//----- Fond en PMMA de 3mm (gris clair)-----
module FOND()
	{
   	color([0.95,0.95,0.95])
	difference()
		{
		rSquare([lrg_gn+2*lrg_flanc,htr_gn+2*lrg_flanc], ray_gn+lrg_flanc, false);
		translate ([+lrg_flanc,htr_gn/2+jeu_gn_flanc+lrg_flanc/2]) circle(r=ray_vis,center=true);
		translate ([-lrg_gn/2+1.5*jeu_gn_flanc,htr_gn/2-1.5*jeu_gn_flanc]) circle(r=ray_vis,center=true);
		translate ([+lrg_gn/2-1.5*jeu_gn_flanc,htr_gn/2-1.5*jeu_gn_flanc]) circle(r=ray_vis,center=true);
		translate ([-lrg_gn/2+1.5*jeu_gn_flanc,-htr_gn/2+1.5*jeu_gn_flanc]) circle(r=ray_vis,center=true);
		translate ([+lrg_gn/2-1.5*jeu_gn_flanc,-htr_gn/2+1.5*jeu_gn_flanc]) circle(r=ray_vis,center=true);
		}
	}

//----- Anneau ajouté en haut de flanc-----
module ANNEAU()
	{
	translate([0,htr_gn/2+lrg_flanc+ray_anneau])
		{
		difference()
			{
			union()
				{
				circle(r=ray_anneau+lrg_flanc/2,center=true);
				translate([0,-lrg_flanc/2]) square([ray_anneau*4+lrg_flanc*1, ray_anneau+lrg_flanc/2],center=true);
				}
			circle(r=ray_anneau,center=true);
			translate([-ray_anneau*2-lrg_flanc/2, 0]) circle(r=ray_anneau,center=true);
			translate([+ray_anneau*2+lrg_flanc/2, 0]) circle(r=ray_anneau,center=true);
			translate ([+lrg_flanc,-ray_anneau-lrg_flanc/2+jeu_gn_flanc]) circle(r=ray_vis,center=true);
			}
		}
	}

//----- Pate latérale gauche pour la sangle -----
module PATE()
   {
	translate([-lrg_gn/2-lrg_flanc-ray_pate,0])
		difference()
		{
		union()
			{
			circle(r=ray_pate+lrg_flanc/2,center=true);
			translate([0,-lrg_pate]) circle(r=ray_pate+lrg_flanc/2,center=true);
			translate([0,-lrg_pate/2]) square([ray_pate*2+lrg_flanc, lrg_pate],center=true);
					}
		circle(r=ray_pate,center=true);
		translate([0,-lrg_pate]) circle(r=ray_pate,center=true);
		translate([0,-lrg_pate/2]) square([2*ray_pate, lrg_pate],center=true);
		}
	}


//----- Flanc en PMMA de 10mm (gris clair)-----
module FLANC_COMPLET()
   	{
	color([0.80,0.80,1])
		{
		difference()
			{
			FOND();
			GN2(1);
			}
		ANNEAU();
   		PATE();
   		translate([(lrg_gn+(lrg_flanc+jeu_gn_flanc)*2+ray_pate),0]) PATE();
		}
	}

//----- Cerclage étanchéite du bouchon en PMMA de 3 (gris)-----
module CERCLAGE_COMPLET()
   	{
	color([0.95,0.95,0.95])
		{
		difference()
			{
			FOND();
			GN2(1);
			}
		}
	}

//----- Rectangle de découpe du bouchon (rouge)-----
module DECOUPE_BOUCHON()
	{
   	color([1,0,0])
		translate ([0,htr_gn-ray_gn])
			square([lrg_gn+jeu_gn_flanc+lrg_flanc,htr_gn], true);
	}

//----- Rectangle de découpe du bouchon (rouge)-----
module DECOUPE_CERCLAGE()
	{
   	color([1,0,0])
		translate ([0,htr_gn-ray_gn])
			square([lrg_gn+jeu_gn_flanc+lrg_flanc*2,htr_gn], true);
	}

//----- Rectangle de découpe du bas USB (rouge)-----
module DECOUPE_USB()
	{
   	color([1,0,0])
		translate ([0, -htr_gn+ray_gn])
			square([lrg_gn+jeu_gn_flanc+lrg_flanc,htr_gn], true);
	}

//----- Rectangle de découpe moitié droite (rouge)-----
module DECOUPE_MOITIE()
	{
   	color([1,0,0])
		translate ([lrg_gn/2, 0])
			square([lrg_gn,htr_gn*2], true);
	}
//----- Référenciel de 10x10 (vert)-----
module REFERENTIEL()
	{
   	color([0,1,0]) square([10,10], true);
	}

//----- Flanc gauche-----
module CERCLAGE()
	{
   	intersection()
		{
		CERCLAGE_COMPLET();
		DECOUPE_CERCLAGE();
		}
	}

//----- Flanc gauche-----
module FLANC_GAUCHE()
	{
   	difference()
		{
		FLANC_COMPLET();
		DECOUPE_BOUCHON();
		DECOUPE_USB();
		DECOUPE_MOITIE();
		}
	}

//----- Flanc droit-----
module FLANC_DROIT()
	{
	intersection()
		{
		difference()
			{
			FLANC_COMPLET();
			DECOUPE_BOUCHON();
			DECOUPE_USB();
			}
		DECOUPE_MOITIE();
		}
	}

//----- Bouchon-----
module BOUCHON()
	{
	intersection()
		{
		FLANC_COMPLET();
		DECOUPE_BOUCHON();
		}
	}

//----- Fond usb-----
module FOND_USB()
	{
	intersection()
		{
		FLANC_COMPLET();
		DECOUPE_USB();
		}
	}

//----- Fond usb-----
module POUSSOIR(lng, lrg=lrg_bp)
	{
	cube([15,lng -lrg,lrg], true);
	translate([0,-lng/2+lrg/2,0]) rotate([0,90,0])cylinder(15,lrg/2,lrg/2,true);
	translate([0,+lng/2-lrg/2,0]) rotate([0,90,0])cylinder(15,lrg/2,lrg/2,true);
	}


//translate([-250,0]) GN2(0);
//translate([-150,0]) FLANC_COMPLET();
//translate([-150,0]) DECOUPE_BOUCHON();
//translate([-150,0]) DECOUPE_USB();
//translate([-150,0]) DECOUPE_MOITIE();

FOND();
translate([0,25])  CERCLAGE();
translate([0,+92]) REFERENTIEL();

translate([+110,0]) FLANC_GAUCHE();
translate([+30,0])  FLANC_DROIT();
translate([+175,20]) rotate(90) BOUCHON();
translate([+40,-20]) rotate(90) FOND_USB();
